import { Component, OnInit, Input } from '@angular/core';
import { MvpServices } from '../../../../services/mvp-services';

import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';

@Component({
  selector: 'app-mvp-add-mapping-algorithm',
  templateUrl: './mvp-add-mapping-algorithm.component.html',
  styleUrls: ['./mvp-add-mapping-algorithm.component.scss']
})
export class MvpAddMappingAlgorithmComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  @Input() algorithm;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    public mvpServices: MvpServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

    getState() {
    return this.ngRedux.getState();
  }

  addAlgorithmToMvpObject() {
    var algorithmInput = this.algorithm.trim();
    if (algorithmInput != null && algorithmInput.length > 0) {
      this.mvpObject.object = algorithmInput;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
